/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateLinePointToPoint.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "cApplication.h"
#include "cLine.h"

//	Creates a line using the two given points
//	and returns the line created
//	After creation the line is AutoConstrained.

HRESULT CreateLinePointToPoint(IPoint *startPoint, IPoint *endPoint, ILine **dLine1)
{

	START_METHOD("CreateLinePointToPoint")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IVector *startVector3D = NULL;
	status = startPoint->GetPosition(&startVector3D);
	CHECK_RETURN_STATUS(status)

	IVector *endVector3D = NULL;
	status = endPoint->GetPosition(&endVector3D);
	CHECK_RETURN_STATUS(status)

	// Create basic straight line
	IBasicStraight *curve1 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(startVector3D,
													endVector3D, &curve1);
	CHECK_RETURN_STATUS(status)

	// Create aLine object
	ILine *line1 = NULL;
	status = activeSketch->CreateLine(CAST(ICurve, curve1), &line1);
	CHECK_RETURN_STATUS(status)
	*dLine1 = line1;

	// Apply AutoConstrain on the line created
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, line1));
	CHECK_RETURN_STATUS(status)

	// Set the selection to the line created
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, line1));
	CHECK_RETURN_STATUS(status)

	END_METHOD("CreateLinePointToPoint")
}
